implementation module deltaFileSelect


import Events, intrface, clCrossCall


/*	With the functions defined in this module standard file selector
	dialogs can be opened, which provide a user-friendly way to select
	input or output files. The lay-out of these dialogs depends on the
	(version of the) operating system.
*/

/*	SelectInputFile opens a dialog in which the user can traverse the
	file system to select an existing file. The boolean result indicates
	whether the user pressed the Open button (True) or the Cancel button
	(False). The String result contains the complete pathname of the
	selected file. When Cancel was pressed an empty string will be
	returned. */
	
SelectInputFile :: !*s !(IOState *s) -> (!Bool, !String, !*s, !IOState *s)
SelectInputFile s iostate = ( success, path, news, PackIOState newadm newos )
where
  (adm, os)  =  UnpackIOStateWithCheck iostate
  filecci    =  ( CcRqFILEOPENDIALOG, 0,0,0,0,0,0 )
  (rcci, (news,newadm), os2) 
             =  IssueCleanRequest StdCallback filecci (s, adm) os
  (success, path, newos) 
             =  case rcci of
			     ( CcRETURN2, 0, _,_,_,_,_)    -> ( False, "", os2 )
				 ( CcRETURN2, _, ptr, _,_,_,_) -> ( True, path, os3 )
				                                  where (path, os3) = WinGetCStringAndFree ptr os2
                 ( CcWASQUIT, _,_,_,_,_,_)     -> ( False, "", os2 ) 
				 other                         -> abort "[SelectInputFile`] expected CcRETURN2 value."



/*	SelectOutputFile opens a dialog in which the user can specify the
	name of a file to write to in a certain directory. The first argument
	is the prompt of the dialog (default: "Save As:"), the second
	argument is the default filename. The boolean result indicates
	whether the user pressed the Save button (True) or the Cancel button
	(False). The String result contains the complete pathname of the
	selected file. When Cancel was pressed an empty string will be
	returned. When a file with the indicated name already exists in the
	indicated directory a confirm dialog will be opened. */

SelectOutputFile :: !String !String !*s !(IOState *s) -> (!Bool, !String, !*s, !IOState *s)
SelectOutputFile prompt filename s iostate = ( success, path, news, PackIOState newadm newos )
where
  (adm, os)         =  UnpackIOStateWithCheck iostate
  (promptptr, os2)  =  WinMakeCString prompt os
  (nameptr, os3)    =  WinMakeCString filename os2
  savecci           =  ( CcRqFILESAVEDIALOG, promptptr, nameptr, 0,0,0,0 )
  (rcci, (news,newadm), os4) 
                    =  IssueCleanRequest StdCallback savecci (s, adm) os3
  os5               =  WinReleaseCString nameptr (WinReleaseCString promptptr os4)
  (success, path, newos) 
             =  case rcci of
			     ( CcRETURN2, 0, _,_,_,_,_)    -> ( False, "", os5 )
				 ( CcRETURN2, _, ptr, _,_,_,_) -> ( True, path, os6 )
				                                  where (path, os6) = WinGetCStringAndFree ptr os5
                 ( CcWASQUIT, _,_,_,_,_,_)     -> ( False, "", os5 ) 
				 other                         -> abort "[SelectOutputFile`] expected CcRETURN2 value."
 


